VehicleCombat = { 
    description = "VehicleCombat"
}
local config = require("modules/utils/config")

curSettings = config.loadFile("Data/config.json")

--Multiplier for motorcycle hp
Motorcycle_HP_Multiplier = curSettings.Motorcycle_HP_Multiplier
Car_HP_Multiplier = curSettings.Car_HP_Multiplier

--Multiplier of all enemies that spawn except maxtac
 Backup_Enemies_Scalar = curSettings.Backup_Enemies_Scalar

--Multiplier of how many maxtac enemies spawn
 Maxtac_Scalar = curSettings.Maxtac_Scalar

--Maxtac hp multiplier
 Maxtac_HP = curSettings.Maxtac_HP

--Maxtac dps multiplier
 Maxtac_DPS = curSettings.Maxtac_DPS
	 
--Duration in seconds of the call that triggers the prevention system
Call_Reinforcements_Duration = curSettings.Call_Reinforcements_Duration

Time_Between_Calls = curSettings.Time_Between_Calls

function VehicleCombat:new()

    defaultSettings = {
	--Multiplier for motorcycle hp
	Motorcycle_HP_Multiplier = 1,
	
	--Multiplier for car HP
	Car_HP_Multiplier = 1,

	--Multiplier of all enemies that spawn except maxtac
	 Backup_Enemies_Scalar = 1,

	--Multiplier of how many maxtac enemies spawn
	 Maxtac_Scalar = 1,

	--Maxtac hp multiplier
	 Maxtac_HP = 2,

	--Maxtac dps multiplier
	 Maxtac_DPS = 1,

	Call_Reinforcements_Duration = 8,
	
	Time_Between_Calls = 12,

    }
	
	



	local nativeSettings = GetMod("nativeSettings")
    if not nativeSettings then
        print("[Vehicle Combat] Error: NativeSettings lib not found!")
        return
    end
    nativeSettings.addTab("/Vehicle Combat", Tab_Name)
	nativeSettings.addSubcategory("/Vehicle Combat/Backup System", Subcategory_1)
    nativeSettings.addSubcategory("/Vehicle Combat/Vehicle Settings", Subcategory_2)
	
	--Enable reloading mods on exit (courtesy of keanuWheeze)
	local fromMods = false

	Observe("PauseMenuGameController", "OnMenuItemActivated", function (_, _, target)
		fromMods = target:GetData().label == "Mods"
	end)

	Observe("gameuiMenuItemListGameController", "OnMenuItemActivated", function (_, _, target)
		fromMods = target:GetData().label == "Mods"
	end)

	Observe("SettingsMainGameController", "RequestClose", function () -- Handle mod settings close
		if fromMods then
			reloadVCMods()
			fromMods = false
		end
	end)

	--Vehicle settings floats
	 nativeSettings.addRangeFloat("/Vehicle Combat/Vehicle Settings", Car_Health, Car_Health_Description, 0.5, 10, 0.1, "%.2f", curSettings.Car_HP_Multiplier, curSettings.Car_HP_Multiplier, function(value)
		curSettings.Car_HP_Multiplier = value
		config.saveFile("Data/config.json", curSettings)
	 end)
	 
	 nativeSettings.addRangeFloat("/Vehicle Combat/Vehicle Settings", Motorcycle_Health, Motorcycle_Health_Description, 0.5, 10, 0.1, "%.2f", curSettings.Motorcycle_HP_Multiplier, defaultSettings.Motorcycle_HP_Multiplier, function(value)
		curSettings.Motorcycle_HP_Multiplier = value
		config.saveFile("Data/config.json", curSettings)
	 end)
	 
	--Back up system floats
	 nativeSettings.addRangeInt("/Vehicle Combat/Backup System", Backup_Enemies, Backup_Enemies_Description, 1, 10, 1, curSettings.Backup_Enemies_Scalar, defaultSettings.Backup_Enemies_Scalar, function(value)
		curSettings.Backup_Enemies_Scalar = value
		config.saveFile("Data/config.json", curSettings)
	 end)
	 nativeSettings.addRangeInt("/Vehicle Combat/Backup System", Maxtac_Enemies, Maxtac_Enemies_Description, 1, 10, 1, curSettings.Maxtac_Scalar, defaultSettings.Maxtac_Scalar, function(value)
		curSettings.Maxtac_Scalar = value
		config.saveFile("Data/config.json", curSettings)
	 end)
	nativeSettings.addRangeFloat("/Vehicle Combat/Backup System", Maxtac_Health, Maxtac_Health_Description, 0.5, 10, 0.1, "%.2f", curSettings.Maxtac_HP, defaultSettings.Maxtac_HP, function(value)
		curSettings.Maxtac_HP = value
		config.saveFile("Data/config.json", curSettings)
	 end)
	 
	 nativeSettings.addRangeFloat("/Vehicle Combat/Backup System", Maxtac_Damage, Maxtac_Damage_Description, 0.5, 10, 0.1, "%.2f", curSettings.Maxtac_DPS, defaultSettings.Maxtac_DPS, function(value)
		curSettings.Maxtac_DPS = value
		config.saveFile("Data/config.json", curSettings)
	 end)

	 nativeSettings.addRangeInt("/Vehicle Combat/Backup System", Call_Duration, Call_Duration_Description, 1, 20, 1, curSettings.Call_Reinforcements_Duration, defaultSettings.Call_Reinforcements_Duration, function(value)
		curSettings.Call_Reinforcements_Duration = value
		config.saveFile("Data/config.json", curSettings)
	 end)

	 nativeSettings.addRangeInt("/Vehicle Combat/Backup System", Time_Between_Calls_String, Time_Between_Calls_String_Description, 1, 30, 1, curSettings.Time_Between_Calls, defaultSettings.Time_Between_Calls, function(value)
		curSettings.Time_Between_Calls = value
		config.saveFile("Data/config.json", curSettings)
	 end)


end
function refreshVariables()
	--Multiplier for motorcycle hp
	Motorcycle_HP_Multiplier = curSettings.Motorcycle_HP_Multiplier
	Car_HP_Multiplier = curSettings.Car_HP_Multiplier

	--Multiplier of all enemies that spawn except maxtac
	 Backup_Enemies_Scalar = curSettings.Backup_Enemies_Scalar

	--Multiplier of how many maxtac enemies spawn
	 Maxtac_Scalar = curSettings.Maxtac_Scalar

	--Maxtac hp multiplier
	 Maxtac_HP = curSettings.Maxtac_HP

	--Maxtac dps multiplier
	 Maxtac_DPS = curSettings.Maxtac_DPS
	 
	 Time_Between_Calls = curSettings.Time_Between_Calls
	 
	 Call_Reinforcements_Duration = curSettings.Call_Reinforcements_Duration
end
function reloadVCMods()
	refreshVariables()
	dofile("Modules/Prevention Data.lua")
	dofile("Modules/Call Reinforcements.lua")
	dofile("Modules/Vehicle Weapons.lua")
	
end
return VehicleCombat:new()
